% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[0.00115
0.06091
0.10816
0.14128
0.17197
0.19983
0.22548
0.25092
0.27253
0.29171
0.3121
0.33128
0.35551
0.38479
0.41023
0.43446
0.46112
0.50069
0.54532
0.57338
0.59761
0.62043
0.6384
0.65738
0.67535
0.69958
0.72624
0.75309
0.78358
0.81811
0.86395
0.91362
0.94552
1.00024];
    SFE=[-0.01396
0.24388
0.89877
1.57945
2.42515
3.40492
4.41047
5.64807
6.91661
8.09233
9.26289
10.53143
12.06296
14.07922
15.57465
16.84319
17.72498
18.50364
17.95188
16.84319
15.54371
14.14626
12.97054
11.67106
10.40251
8.77301
7.21054
5.7151
4.28155
2.88409
1.57945
0.63578
0.21294
-0.01396];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=3;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=3.84;
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=64;
    poisson_ratio=0.0000;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='s';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=3;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  1.0000,  0.1667];
    Xdist_range=[-20.0000, 20.0000,  10.0000];
    Xwid_range =[  0.0000, 10.0000,  0.2000];
    Xalpha_range=[ 0.0000,  2.00000, 1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_lsq_curvefit';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
 
    % % Interplanar distance ?x (unit: A) 

    Inpas=3.325538;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
